/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/

#ifndef __APIPARAMS_H
#define __APIPARAMS_H

typedef struct {
	char *m_szAPIName;
	long m_lParamCount;
	char **m_szParams;

	/*
		If m_fExcept is FALSE, then m_drExpected is the expected return value from the API.
		If m_fExcept is TRUE, then the API should return anything but the m_drExpected value.
	*/
	DRM_BOOL m_fExcept;
	DRM_RESULT m_drExpected;
} TAPIParams;

void FreeAPIParams(TAPIParams *pParams);

int ParseTCID(char *pLine, long *plNextTCID, char **ppNextTCTitle);
int ParseAPI(char *pLine, TAPIParams *pParams);

char* TrimSpace(char *pLine);
char* StringDup(char *pStr);
#endif
